Option Explicit

'////////////////////////////////////////////////////////////
' ֐FIsFileExists
' T@vFt@C̑݃`FbN
' @F@strFilePathFt@C̃pX
' ߂lF:TrueA݂Ȃ:False
'////////////////////////////////////////////////////////////
Function IsFileExists(ByVal strFilePath)
    Dim objFso
    Set objFso = WScript.CreateObject("Scripting.FileSystemObject")
    IsFileExists = objFso.FileExists(strFilePath)
    Set objFso = Nothing
End Function

'////////////////////////////////////////////////////////////
' ֐FIsFolderExists
' T@vFtH_̑݃`FbN
' @F@strFolderPathFtH_̃pX
' ߂lF:TrueA݂Ȃ:False
'////////////////////////////////////////////////////////////
Function IsFolderExists(ByVal strFolderPath)
    Dim objFso
    Set objFso = WScript.CreateObject("Scripting.FileSystemObject")
    IsFolderExists = objFso.FolderExists(strFolderPath)
    Set objFso = Nothing
End Function


'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
' t@C̃NX
'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
Class FileCommon
    Private mstrMessage
    'Constructor
    Private Sub Class_Initialize()
        mstrMessage = ""
    End Sub

    '////////////////////////////////////////////////////////////
    ' vpeBFMessage
    ' T@@@@vFbZ[W
    '////////////////////////////////////////////////////////////
    Public Property Get Message()
        Message = mstrMessage
    End Property
    Private Property Let Message(ByVal strMsg)
        mstrMessage = strMsg
    End Property

    '////////////////////////////////////////////////////////////
    ' \bhFCreateFolder
    ' T@@@vFtH_쐬
    ' @@@F@strFolderPathFtH_pX
    ' ߁@@lF:TrueAs:False
    '////////////////////////////////////////////////////////////
    Public Function CreateFolder(ByVal strFolderPath)
        CreateFolder = False
        On Error Resume Next

        Dim blnExists
        blnExists = IsFolderExists(strFolderPath)
        If (blnExists = True) Then
            CreateFolder = True
            Exit Function
        End If

        Dim objFso
        Set objFso = WScript.CreateObject("Scripting.FileSystemObject")
        objFso.CreateFolder strFolderPath
        Set objFso = Nothing
        If Not (Err.Number = 0) Then
            Message = CStr(Err.Number) & ":" & Err.Description
            Err.Clear
            Exit Function
        End If
        
        On Error GoTo 0
        CreateFolder = True
    End Function

    '////////////////////////////////////////////////////////////
    ' \bhFFileDelete
    ' T@@@vFt@C폜
    ' @@@F@strFolderPathFtH_pX
    ' ߁@@lF:TrueAs:False
    '////////////////////////////////////////////////////////////
    Public Function FileDelete(ByVal strFilePath)
        FileDelete = False
        On Error Resume Next

        Dim blnExists
        blnExists = IsFileExists(strFilePath)
        If (blnExists = False) Then
            FileDelete = True
            Exit Function
        End If

        Dim objFso
        Set objFso = WScript.CreateObject("Scripting.FileSystemObject")
        objFso.DeleteFile strFilePath
        Set objFso = Nothing

        If Not (Err.Number = 0) Then
            Message = CStr(Err.Number) & ":" & Err.Description
            Err.Clear
            Exit Function
        End If

        On Error GoTo 0
        FileDelete = True
    End Function

    '////////////////////////////////////////////////////////////
    ' \bhFFolderDelete
    ' T@@@vFtH_폜
    ' @@@F@strFolderPathFtH_pX
    ' ߁@@lF:TrueAs:False
    '////////////////////////////////////////////////////////////
    Public Function FolderDelete(ByVal strFolderPath)
        FolderDelete = False
        On Error Resume Next
        Dim blnExists
        blnExists = IsFolderExists(strFolderPath)
        If (blnExists = False) Then
            FolderDelete = True
            Exit Function
        End If

        Dim objFso
        Set objFso = WScript.CreateObject("Scripting.FileSystemObject")
        objFso.DeleteFolder strFolderPath
        Set objFso = Nothing
        If Not (Err.Number = 0) Then
            Message = CStr(Err.Number) & ":" & Err.Description
            Err.Clear
            Exit Function
        End If

        On Error GoTo 0
        FolderDelete = True
    End Function

    '////////////////////////////////////////////////////////////
    ' \bhFFileCopy
    ' T@@@vFt@CRs[
    ' @@@F@strFromFRs[t@C
    ' @@@@@@AstrToFRs[t@C
    ' ߁@@lF:TrueAs:False
    '////////////////////////////////////////////////////////////
    Public Function FileCopy(ByVal strFrom, ByVal strTo)
        FileCopy = False
        On Error Resume Next

        Dim objFso
        Set objFso = WScript.CreateObject("Scripting.FileSystemObject")
        objFso.CopyFile strFrom, strTo
        Set objFso = Nothing
        If Not (Err.Number = 0) Then
            Message = CStr(Err.Number) & ":" & Err.Description
            Err.Clear
            Exit Function
        End If

        On Error GoTo 0
        FileCopy = True
    End Function

    '////////////////////////////////////////////////////////////
    ' \bhFFolderCopy
    ' T@@@vFtH_Rs[
    ' @@@F@strFromFRs[tH_
    ' @@@@@@AstrToFRs[tH_
    ' ߁@@lF:TrueAs:False
    '////////////////////////////////////////////////////////////
    Public Function FolderCopy(ByVal strFrom, ByVal strTo)
        FolderCopy = False
        On Error Resume Next

        Dim objFso
        Set objFso = WScript.CreateObject("Scripting.FileSystemObject")
        objFso.CopyFolder strFrom, strTo
        Set objFso = Nothing
        If Not (Err.Number = 0) Then
            Message = CStr(Err.Number) & ":" & Err.Description
            Err.Clear
            Exit Function
        End If

        On Error GoTo 0
        FolderCopy = True
    End Function

    '////////////////////////////////////////////////////////////
    ' \bhFFileMove
    ' T@@@vFt@Cړ
    ' @@@F@strFromFRs[tH_
    ' @@@@@@AstrToFRs[tH_
    ' ߁@@lF:TrueAs:False
    '////////////////////////////////////////////////////////////
    Public Function FileMove(ByVal strFrom, ByVal strTo)
        FileMove = False
        On Error Resume Next

        Dim objFso
        Set objFso = WScript.CreateObject("Scripting.FileSystemObject")
        objFso.MoveFile strFrom, strTo
        Set objFso = Nothing
        If Not (Err.Number = 0) Then
            Message = CStr(Err.Number) & ":" & Err.Description
            Err.Clear
            Exit Function
        End If

        On Error GoTo 0
        FileMove = True
    End Function

    '////////////////////////////////////////////////////////////
    ' \bhFFolderMove
    ' Tv@@@FtH_Rs[
    ' @@@F@strFromFRs[tH_
    ' @@@@@@AstrToFRs[tH_
    ' ߁@@lF:TrueAs:False
    '////////////////////////////////////////////////////////////
    Public Function FolderMove(ByVal strFrom, ByVal strTo)
        FolderMove = False
        On Error Resume Next

        Dim objFso
        Set objFso = WScript.CreateObject("Scripting.FileSystemObject")
        objFso.MoveFolder strFrom, strTo
        Set objFso = Nothing
        If Not (Err.Number = 0) Then
            Message = CStr(Err.Number) & ":" & Err.Description
            Err.Clear
            Exit Function
        End If

        On Error GoTo 0
        FolderMove = True
    End Function

End Class


'////////////////////////////////////////////////////////////
' eLXgt@C̃NX
'////////////////////////////////////////////////////////////
Class TextFile
    Private mstrMessage
    'Constructor
    Private Sub Class_Initialize()
        mstrMessage = ""
    End Sub

    '////////////////////////////////////////////////////////////
    ' vpeBFMessage
    ' T@@@@vFbZ[W
    '////////////////////////////////////////////////////////////
    Public Property Get Message()
        Message = mstrMessage
    End Property
    Private Property Let Message(ByVal strMsg)
        mstrMessage = strMsg
    End Property

    '////////////////////////////////////////////////////////////
    ' \bhFReadText
    ' T@@@vFw肳ꂽt@Cׂēǂݍ
    ' @@@F@strFilePathFt@C̃pX
    ' ߁@@lFeLXgt@C̓e
    '////////////////////////////////////////////////////////////
    Public Function ReadText(ByVal strFilePath)
        ReadText = False
        On Error Resume Next

        Dim blnRet
        blnRet = IsFileExists(strFilePath)
        If (blnRet = False) Then
            Message = "t@C܂łB"
            Exit Function
        End If

        Dim objFso
        Set objFso = WScript.CreateObject("Scripting.FileSystemObject")
        Dim objFile
        Set objFile = objFso.OpenTextFile(strFilePath, 1, False)
        If Not (Err.Number = 0) Then
            Message = CStr(Err.Number) & ":" & Err.Description
            Err.Clear
            Exit Function
        End If
        Dim strBuf
        strBuf = objFile.ReadAll
        Set objFile = Nothing
        Set objFso = Nothing

        On Error GoTo 0
        ReadText = strBuf
    End Function

    '////////////////////////////////////////////////////////////
    ' \bhFWriteText
    ' T@@@vFw肳ꂽt@Cɏ݂
    ' @@@F@strFilePathFt@C̃pX
    ' @@@@@@AstrValueFޓe
    ' ߁@@lF:TrueAs:False
    '////////////////////////////////////////////////////////////
    Public Function WriteText(ByVal strFilePath, ByVal strValue)
        WriteText = False
        On Error Resume Next

        Dim blnRet
        blnRet = IsFileExists(strFilePath)
        If (blnRet = False) Then
            Message = "t@C܂łB"
            Exit Function
        End If

        If (CStr(strValue) = "") Then
            WriteText = True
            Exit Function
        End If

        Dim objFso
        Set objFso = WScript.CreateObject("Scripting.FileSystemObject")
        Dim objFile
        Set objFile = objFso.OpenTextFile(strFilePath, 8, False)
        objFile.WriteLine strValue
        If Not (Err.Number = 0) Then
            Message = CStr(Err.Number) & ":" & Err.Description
            Err.Clear
            Exit Function
        End If
        Set objFile = False
        Set objFso = Nothing

        On Error GoTo 0
        WriteText = True
    End Function

'201111
    '////////////////////////////////////////////////////////////
    ' \bhFOverwriteText
    ' T@@@vFw肳ꂽt@Cɏ݂i㏑j
    ' @@@F@strFilePathFt@C̃pX
    ' @@@@@@AstrValueFޓe
    ' ߁@@lF:TrueAs:False
    '////////////////////////////////////////////////////////////
    Public Function OverwriteText(ByVal strFilePath, ByVal strValue)
        OverwriteText = False
        On Error Resume Next

        Dim blnRet
        blnRet = IsFileExists(strFilePath)
        If (blnRet = False) Then
            Message = "t@C܂łB"
            Exit Function
        End If

        If (CStr(strValue) = "") Then
            OverwriteText = True
            Exit Function
        End If

        Dim objFso
        Set objFso = WScript.CreateObject("Scripting.FileSystemObject")
        Dim objFile
        Set objFile = objFso.OpenTextFile(strFilePath, 2, False)
        objFile.WriteLine strValue
        If Not (Err.Number = 0) Then
            Message = CStr(Err.Number) & ":" & Err.Description
            Err.Clear
            Exit Function
        End If
        Set objFile = False
        Set objFso = Nothing

        On Error GoTo 0
        OverwriteText = True
    End Function
'201111

    '////////////////////////////////////////////////////////////
    ' \bhFCreateText
    ' T@@@vFeLXgt@C쐬
    ' @@@F@strFilePathFt@C̃pX
    ' ߁@@lF:TrueAs:False
    '////////////////////////////////////////////////////////////
    Public Function CreateText(ByVal strFilePath)
        CreateText = False
        On Error Resume Next

        Dim blnRet
        blnRet = IsFileExists(strFilePath)
        If Not (blnRet = False) Then
            CreateText = True
            Exit Function
        End If

        Dim objFso
        Set objFso = WScript.CreateObject("Scripting.FileSystemObject")
        Dim objFile
        Set objFile = objFso.CreateTextFile(strFilePath, True)
        If Not (Err.Number = 0) Then
            Message = CStr(Err.Number) & ":" & Err.Description
            Err.Clear
            Exit Function
        End If
        objFile.Close
        Set objFile = Nothing
        Set objFso = Nothing

        On Error GoTo 0
        CreateText = True
    End Function

End Class

'////////////////////////////////////////////////////////////
' ֐FIsRegStrExists
' T@vFWXg̃Gg̗L
' @F@lRootFWXg̃[g
' @@@@AstrKeyPathFWXg̃pX
' ߂lF
'////////////////////////////////////////////////////////////
Function IsRegExists(ByVal lRoot, ByVal strKeyPath, ByVal strValueName)
    Set objRegistry = GetObject("winmgmts:\\" & strComputer & "\root\default:StdRegProv")
    objRegistry.GetStringValue lRoot, strKeyPath, strValueName, strValue
    IsRegExists = NOT(IsNull(strValue))
End Function

'////////////////////////////////////////////////////////////
' ֐FGetRegNamesTypes
' T@vFWXg̃Gg̈ꗗ擾
' @F@lRootFWXg̃[g
' @@@@AstrKeyPathFWXg̃pX
' @@@@B[ref]arrValueNamesFGg̔z
' @@@@C[ref]arrValueTypesFGǧ^̔z
'////////////////////////////////////////////////////////////
Function GetRegNamesTypes(ByVal lRoot, ByVal strKeyPath, ByRef arrValueNames,  ByRef arrValueTypes)
    On Error Resume Next
    strComputer = "."
    Set oReg=GetObject("winmgmts:{impersonationLevel=impersonate}!\\" & strComputer & "\root\default:StdRegProv")
    oReg.EnumValues lRoot, strKeyPath, arrValueNames, arrValueTypes
End Function

'////////////////////////////////////////////////////////////
' ֐FGetRegSubkeys
' T@vFWXg̃TuL[̈ꗗ擾
' @F@lRootFWXg̃[g
' @@@@AstrKeyPathFWXg̃pX
' ߂lF
'////////////////////////////////////////////////////////////
Function GetRegSubkeys(ByVal lRoot, ByVal strKeyPath)
    On Error Resume Next
    strComputer = "."
    Set oReg=GetObject("winmgmts:{impersonationLevel=impersonate}!\\" & strComputer & "\root\default:StdRegProv")
    oReg.EnumKey lRoot, strKeyPath, arrSubKeys
    GetRegSubkeys = arrSubKeys
End Function

'////////////////////////////////////////////////////////////
' ֐FGetFileCnt
' T@vFtH_̃t@CċAIɏWv
' @F@strDirNameFtH_
' @@@@AiCntFt@C
' ߂lF
'////////////////////////////////////////////////////////////
Function GetFileCnt(ByVal strDirName, ByRef iCnt)
    On Error Resume Next
    Dim f_objFso, f_objFolder
    Set f_objFso = WScript.CreateObject("Scripting.FileSystemObject")
    Set f_objFolder = f_objFso.GetFolder(strDirName)
    iCnt = iCnt + f_objFolder.Files.Count

    'ċAIɃTutH_̃t@C
    For Each DirName In f_objFolder.SubFolders
        GetFileCnt DirName, iCnt
    Next
    Set f_objFolder = Nothing
    Set f_objFso = Nothing
End Function

'////////////////////////////////////////////////////////////
' ֐FMakeZipFormDir
' T@vFw肳ꂽtH_wZIPňk
' @F@SrcDirNameFkΏۃtH_
' @@@@ADestDirNameFZIP쐬tH_
'////////////////////////////////////////////////////////////
Function MakeZipFromDir(ByVal SrcDirName, ByVal DestDirName)
    Dim objFso, objApp
    Set objFso = WScript.CreateObject("Scripting.FileSystemObject")
    Set objApp = WScript.CreateObject("Shell.Application")

    't@CҏW
    Dim strFileName, strFileFullPath
    strFileName = "TKCPCRepResult" & Year(Date) & _
      Right("0" & Month(Date),2) & Right("0" & Day(Date),2) & _
      Right("0" & Hour(Time),2) & Right("0" & Minute(Time),2) & _
      Right("0" & Second(Time),2) &  ".zip"
    strFileFullPath = DestDirName & "\" & strFileName

    'ZIPt@C쐬
    Dim fZip
    Set fZip = objFso.CreateTextFile(strFileFullPath)
    fZip.Write "PK" & Chr(5) & Chr(6) & String(18,0)
    fZip.Close
    Set fZip = Nothing

    'ZIPt@Cփt@CǉASleepňk҂
    Dim objZip
    Set objZip = objApp.NameSpace(strFileFullPath)
    objZip.CopyHere SrcDirName
    Do Until objZip.Items.Count = 1
        WScript.sleep 100
    Loop

    Set objZip = Nothing
    Set objFso = Nothing
    Set objApp = Nothing
End Function

'////////////////////////////////////////////////////////////
' ֐FMakeZipFormFiles
' T@vFw肳ꂽtH_̃t@CwZIPňk
' @F@SrcDirNameFkΏۃtH_
' @@@@ADestDirNameFZIP쐬tH_
'////////////////////////////////////////////////////////////
Function MakeZipFromFiles(ByVal SrcDirName, ByVal DestDirName)
    Dim objFso, objApp
    Set objFso = WScript.CreateObject("Scripting.FileSystemObject")
    Set objApp = WScript.CreateObject("Shell.Application")

    't@CҏW
    Dim strFileName, strFileFullPath
    strFileName = "TKCPCInfResult" & Year(Date) & _
      Right("0" & Month(Date),2) & Right("0" & Day(Date),2) & _
      Right("0" & Hour(Time),2) & Right("0" & Minute(Time),2) & _
      Right("0" & Second(Time),2) &  ".zip"
    strFileFullPath = DestDirName & "\" & strFileName

    'ZIPt@C쐬
    Dim fZip
    Set fZip = objFso.CreateTextFile(strFileFullPath)
    fZip.Write "PK" & Chr(5) & Chr(6) & String(18,0)
    fZip.Close
    Set fZip = Nothing

    Dim objFolder, objFiles
    Set objFolder = objFso.GetFolder(SrcDirName)
    Set objFiles = objFolder.Files

    'ZIPt@Cփt@CǉASleepňk҂
    Dim objZip
    Set objZip = objApp.NameSpace(strFileFullPath)
    Dim DoneCnt, file
    DoneCnt = 0
    For each file in objFiles
        objZip.CopyHere file.Path
        DoneCnt = DoneCnt + 1
        Do Until objZip.Items.Count = DoneCnt
            WScript.sleep 100
        Loop
    Next

    Set objZip = Nothing
    Set objFolder = Nothing
    Set objFiles = Nothing
    Set objFso = Nothing
    Set objApp = Nothing
End Function

'201111
'////////////////////////////////////////////////////////////
' ֐FGetWaitMsg
' T@vFEFCgbZ[W\
' @F̍ڔԍ(1`8)
' @@@@@1̏ꍇ̂݁A[w
' @@@@v[VXe[g(0`3)
' ߂lFEFCgbZ[W
'////////////////////////////////////////////////////////////
Function GetWaitMsg(ByVal iRow, ByVal PromoState)
    On Error Resume Next
    Dim conMsg, strMsg, conMsgPrmo
    conMsg       = Array("PD{@@@@@@@@@@@@@@@", _
                         "QDn[hEFȀ@@@@@@@@@@", _
                         "RDnȑ@@@@@@@@@@@@@@", _
                         "SDhd̏@@@@@@@@@@@@@@", _
                         "TDCXg[ĂvÖꗗ", _
                         "UDlbg[N̏@@@@@@@@@@", _
                         "VDZLeB̏@@@@@@@@@@", _
                         "WDO@@@@@@@@@@@@@@@@")
    conMsgPrmo   = Array("PDiKvȏ@@@@@@@@@", _
                         "QD{@@@@@@@@@@@@@@@", _
                         "RDn[hEFȀ@@@@@@@@@@", _
                         "SDnȑ@@@@@@@@@@@@@@", _
                         "TDhd̏@@@@@@@@@@@@@@", _
                         "UDCXg[ĂvÖꗗ", _
                         "VDlbg[N̏@@@@@@@@@@", _
                         "WDZLeB̏@@@@@@@@@@", _
                         "XDO@@@@@@@@@@@@@@@@")
    Const ING = "@EEE@W@"
    Const FIN = "@EEE@W"
    Const YET = "@@@@@@@@@"

    strMsg =             "̎WsłB@@@@@@@@@" & YET & vbCrLf
    strMsg = strMsg &    "΂炭҂B@@@@@@@@@" & YET & vbCrLf
    strMsg = strMsg &    "@@@@@@@@@@@@@@@@@@@@@" & YET & vbCrLf
    strMsg = strMsg &    "sis󋵁t@@@@@@@@@@@@@@@" & YET & vbCrLf
    Dim i, tmpAry
    If (PromoState = "1") or _
       (PromoState = "2") Then
       iRow = iRow + 1
       tmpAry = conMsgPrmo
    Else
       tmpAry = conMsg
    End If
    For i = 0 To UBound(tmpAry) Step 1
        if i + 1 = iRow Then ' 
            strMsg = strMsg & tmpAry(i) & ING & vbCrLf
        Elseif i + 1 < iRow Then '
            strMsg = strMsg & tmpAry(i) & FIN & vbCrLf
        Else '
            strMsg = strMsg & tmpAry(i) & YET & vbCrLf
        End If
    Next
    GetWaitMsg = strMsg
End Function
'201111

'////////////////////////////////////////////////////////////
' ֐FGetSelected
' T@vFIʂԂB
' @FI
' ߂lF or 
'////////////////////////////////////////////////////////////
Function GetSelected(ByVal bSelected)
    On Error Resume Next
    If (bSelected) Then
        GetSelected = ""
    Else
        GetSelected = ""
    End If
End Function

'////////////////////////////////////////////////////////////
' ֐FGetEditedRow
' T@vFҏWʂԂB
' @F@sItemNameFږ
' @@@@AsValFW
' ߂lFҏWPs
'////////////////////////////////////////////////////////////
Function GetEditedRow(ByVal sItemName, ByVal sVal)
    On Error Resume Next
    Const LEN_ITEM = 32 'ږ̒
    Const LEN_ROW  = 80 'Ps̒
    Const DELIM    = "F"
    Dim sRet
    sRet = "@" & sItemName
    if (LEN_ITEM > LenEx(sRet)) Then
        sRet = sRet & Space(LEN_ITEM - LenEx(sRet))
    End If
    sRet = sRet & DELIM & sVal
    GetEditedRow = sRet '201212
End Function

'////////////////////////////////////////////////////////////
' ֐FGetEditedRowArray
' T@vFҏWʂԂB
' @F@sItemNameFږ
' @@@@AsValFWʂ̔z
' ߂lFҏWz
'////////////////////////////////////////////////////////////
Function GetEditedRowArray(ByVal sItemName, ByVal ary)
    On Error Resume Next
    Const LEN_ITEM = 32 'ږ̒
    Const LEN_ROW  = 80 'Ps̒
    Const DELIM    = "F"
    Dim sRet, tmpItem, i
    sRet = "@" & sItemName
    if (LEN_ITEM > LenEx(sRet)) Then
        sRet = sRet & Space(LEN_ITEM - LenEx(sRet))
    End If
    sRet = sRet & DELIM
    i = 0
    For Each tmpItem In ary
        If i <> 0 Then
            sRet = sRet & Space(LEN_ITEM + LenEx(DELIM))
        End If
        sRet = sRet & tmpItem & vbCrLf
        i = i + 1
    Next
    GetEditedRowArray = DelLastLF(sRet) '201212
End Function

'////////////////////////////////////////////////////////////
' ֐FUBoundEx
' T@vFz̃CfbNX̍őlԂB
' @@@@vfȂIzɑΉBi-1ԂBj
' @FarrayFz
' ߂lFz̃CfbNX̍ől
'////////////////////////////////////////////////////////////
Function UBoundEx(ByRef array)
    On Error Resume Next
    UBoundEx = UBound(array)
    If Err.Number <> 0 Then
        Err.Clear
        UBoundEx = -1
    End If
End Function

'////////////////////////////////////////////////////////////
' ֐FFindTkcStr
' T@vFw肳ꂽɕusjbv܂܂Ă邩mF
' @@@@usjbv͑OpA啶͖ȂB
' @FΏە
' ߂lFTrue:usjbv݂AFalse:Ȃ
'////////////////////////////////////////////////////////////
Function FindTkcStr(ByVal str)
    Dim ret
    ret = InStr(1, str, "TKC", vbTextCompare) 'eLXg[hiOpA啶ʂȂj
    If IsNull(ret) Then
        FindTkcStr = False
    Else
        FindTkcStr = (ret > 0)
    End If
End Function

'////////////////////////////////////////////////////////////
' ֐FFindSqlExeStr
' T@vFw肳ꂽSQLServerexẽtpX܂܂Ă邩mF
' @F
' @@@@Ώە
' ߂lFTrue:AFalse:Ȃ
'////////////////////////////////////////////////////////////
Function FindSqlExeStr(ByVal str, ByVal path)
    Dim ret
    ret = InStr(1, str, path & "\Binn\sqlservr.exe", vbTextCompare) 'eLXg[hiOpA啶ʂȂj
    If IsNull(ret) Then
        FindSqlExeStr = False
    Else
        FindSqlExeStr = (ret > 0)
    End If
End Function

'////////////////////////////////////////////////////////////
' ֐FGetInt2Bool
' T@vFBoolɕϊ
' @F1 or 0
' ߂lF1̎TrueAȊOFalse
'////////////////////////////////////////////////////////////
Function GetInt2Bool(ByVal i)
    GetInt2Bool = (i = 1)
End Function

'////////////////////////////////////////////////////////////
' ֐FLenEx
' T@vF̃oCgԂ
' @FΏە
' ߂lFoCg
'////////////////////////////////////////////////////////////
Function LenEx(ByVal strVal)  
    Dim i, strChr
    LenEx = 0
    If Trim(strVal) <> "" Then
        For i = 1 To Len(strVal)  
            strChr = Mid(strVal, i, 1)
            'QoCǵ{Q  
            If (Asc(strChr) And &HFF00) <> 0 Then
                LenEx = LenEx + 2
            Else 
                LenEx = LenEx + 1
            End If
        Next
    End If
End Function

'////////////////////////////////////////////////////////////
' ֐FGetEditedIeRowArray
' T@vFҏWʂԂB
' @F@sItemNameFږ
' @@@@AsValFWʂ̔z
' ߂lFҏWz
'////////////////////////////////////////////////////////////
Function GetEditedIeRowArray(ByVal sItemName, ByVal ary)
    On Error Resume Next
    Const LEN_ITEM = 56 'ږ̒
    Const LEN_ROW  = 160 'Ps̒
    Const DELIM    = "F"
    Dim sRet, tmpItem, i
    sRet = "@" & sItemName
    if (LEN_ITEM > LenEx(sRet)) Then
        sRet = sRet & Space(LEN_ITEM - LenEx(sRet))
    End If
    sRet = sRet & DELIM
    If UboundEx(ary) = -1 Then
        sRet = sRet & vbCrLf
    Else
        i = 0
        For Each tmpItem In ary
            If i <> 0 Then
                sRet = sRet & Space(LEN_ITEM + LenEx(DELIM))
            End If
            sRet = sRet & tmpItem & vbCrLf
            i = i + 1
        Next
    End If
    GetEditedIeRowArray = DelLastLF(sRet) '201212
End Function

'////////////////////////////////////////////////////////////
' ֐FYes2Checked
' T@vFyes  no 󂯎ÁԂ
' @F
' ߂lFyes:, no:
'////////////////////////////////////////////////////////////
Function Yes2Checked(ByVal reg)
    On Error Resume Next
    Dim sRet
    If IsNull(reg) Then
        sRet = MSG_NOTEXIST
    Else
        If reg = MSG_NOTSELECTED Then
            sRet = reg
        Else
            If StrComp(reg, "yes", vbTextCompare) = 0 Then
                sRet = ""
            Else
                sRet = ""
            End If
        End If
    End If
    Yes2Checked = sRet
End Function

'////////////////////////////////////////////////////////////
' ֐FNo2Checked
' T@vFyes  no 󂯎ÁԂ
' @F
' ߂lFyes::, no:
'////////////////////////////////////////////////////////////
Function No2Checked(ByVal reg)
    On Error Resume Next
    Dim sRet
    If IsNull(reg) Then
        sRet = MSG_NOTEXIST
    Else
        If reg = MSG_NOTSELECTED Then
            sRet = reg
        Else
            If StrComp(reg, "no", vbTextCompare) = 0 Then
                sRet = ""
            Else
                sRet = ""
            End If
        End If
    End If
    No2Checked = sRet
End Function

'////////////////////////////////////////////////////////////
' ֐FGetIeValue
' T@vFҏWʂԂB
' @F@sItemNameFږ
' @@@@AsValFW
' ߂lFҏWPs
'////////////////////////////////////////////////////////////
Function GetIeValue(ByVal reg, ByVal ary)
    On Error Resume Next
    Dim sRet
    If IsNull(reg) Then
        sRet = MSG_NOTEXIST
    Else
        If reg = MSG_NOTSELECTED Then
            sRet = reg
        Else
            sRet = ary(reg)
            If Err.Number <> 0 Then
                Err.Clear
                sRet = "ڒl̎擾Ɏs܂B"
            End If
        End If
    End If
    GetIeValue = sRet
End Function

'////////////////////////////////////////////////////////////
' ֐FGetEditedIeRow
' T@vFҏWʂԂB
' @F@sItemNameFږ
' @@@@AsValFW
' ߂lFҏWPs
'////////////////////////////////////////////////////////////
Function GetEditedIeRow(ByVal sItemName, ByVal sVal)
    On Error Resume Next
    Const LEN_ITEM = 56 'ږ̒
    Const LEN_ROW  = 160 'Ps̒
    Const DELIM    = "F"
    Dim sRet
    sRet = "@" & sItemName
    if (LEN_ITEM > LenEx(sRet)) Then
        sRet = sRet & Space(LEN_ITEM - LenEx(sRet))
    End If
    sRet = sRet & DELIM & sVal
    GetEditedIeRow = sRet '201212
End Function

'////////////////////////////////////////////////////////////
' ֐FGetIeDefValue
' T@vFWXg݂Ȃꍇ̃ftHglԂ
' @F@VerFhd̃o[Wiwȏ̏ꍇɏj
' @@@@ADefFftHgl
' @@@@BvalueFWXg̒liNULLl̉\j
' ߂lFvalueNULL̏ꍇDefԂB
'////////////////////////////////////////////////////////////
Function GetIeDefValue(ByVal Ver, ByVal Def, ByVal value)
    On Error Resume Next
    Dim sRet
    If IsNull(value) Then
        If Left(IeVer, 1) >= Ver Then
            sRet = Def
        Else
            sRet = value
        End If
    Else
        sRet = value
    End If
    GetIeDefValue = sRet
End Function

'////////////////////////////////////////////////////////////
' ֐FFindJavaStr
' T@vFw肳ꂽɕui`u`v܂܂Ă邩mF
' @@@@ui`u`v͑OpA啶͖ȂB
' @FΏە
' ߂lFTrue:ui`u`v݂AFalse:Ȃ
'////////////////////////////////////////////////////////////
Function FindJavaStr(ByVal str)
    Dim ret
    ret = InStr(1, str, "JAVA", vbTextCompare) 'eLXg[hiOpA啶ʂȂj
    If IsNull(ret) Then
        FindJavaStr = False
    Else
        FindJavaStr = (ret > 0)
    End If
End Function

'////////////////////////////////////////////////////////////
' ֐FDelLastLF
' T@vFŌ̉sR[h폜
' @F
' ߂lFŌ̉sR[h폜
'////////////////////////////////////////////////////////////
Function DelLastLF(ByVal str)
    Dim intLength, strEnd, ret
    ret = str
    intLength = Len(str)
    strEnd = Right(str, 2)
    If strEnd = vbCrLf Then
        ret = Left(str, intLength - 2)
    End If
    DelLastLF = ret
End Function
